"""ImPlot: Immediate Mode Plotting for ImGui
Python bindings for https://github.com/epezent/implot
"""
# ruff: noqa: E741, B008
from typing import Any, Optional, Tuple, overload
import numpy as np
import enum

from imgui_bundle.imgui import ImVec2, ImVec4, ImU32, ImDrawList, Storage, TextBuffer, ImVec2Like, ImVec4Like
from imgui_bundle.imgui.internal import ImRect
from imgui_bundle import imgui
from imgui_bundle.implot import (
    Range,
    ImAxis,
    Cond,
    Scale,
    ItemFlags,
    Point,
    Location,
    AxisFlags,
    LegendFlags,
    Flags,
    MouseTextFlags,
    SubplotFlags,
    Marker,
    Style,
    InputMap,
)

from imgui_bundle.imgui import (
    ImVector_ImU32,
    ImVector_float,
    ImVector_int,
    ImVector_ColorMod,
    ImVector_StyleMod
)

ImGui_Context = imgui.internal.Context
Colormap = int
ID = int

TimeUnit = int  # enum TimeUnit_
TimeFmt = int  # enum TimeFmt_
DateFmt = int  # enum DateFmt_
Col = int  # enum ImPlotCol_
Bin = int  # enum ImPlotBin_

time_t = int


# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# <litgen_stub> // Autogenerated code below! Do not edit!
####################    <generated_from:implot_internal.h>    ####################
# MIT License

# Copyright (c) 2023 Evan Pezent

# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:

# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

# ImPlot v0.17

# You may use this file to debug, understand or extend ImPlot features but we
# don't provide any guarantee of forward compatibility!

#-----------------------------------------------------------------------------
# [SECTION] Header Mess
#-----------------------------------------------------------------------------



# #ifndef IMGUI_DISABLE
#

# Support for pre-1.84 versions. ImPool's GetSize() -> GetBufSize()

#-----------------------------------------------------------------------------
# [SECTION] Constants
#-----------------------------------------------------------------------------

# Constants can be changed unless stated otherwise. We may move some of these
# to ImPlotStyleVar_ over time.


#-----------------------------------------------------------------------------
# [SECTION] Macros
#-----------------------------------------------------------------------------



#-----------------------------------------------------------------------------
# [SECTION] Forward Declarations
#-----------------------------------------------------------------------------


#-----------------------------------------------------------------------------
# [SECTION] Context Pointer
#-----------------------------------------------------------------------------


#-----------------------------------------------------------------------------
# [SECTION] Generic Helpers
#-----------------------------------------------------------------------------

# Computes the common (base-10) logarithm
# static inline float  ImLog10(float x)  { return log10f(x); }    /* original C++ signature */
@overload
def im_log10(x: float) -> float:
    """(private API)"""
    pass
# static inline double ImLog10(double x) { return log10(x);  }    /* original C++ signature */
@overload
def im_log10(x: float) -> float:
    """(private API)"""
    pass
# static inline float  ImSinh(float x)   { return sinhf(x);  }    /* original C++ signature */
@overload
def im_sinh(x: float) -> float:
    """(private API)"""
    pass
# static inline double ImSinh(double x)  { return sinh(x);   }    /* original C++ signature */
@overload
def im_sinh(x: float) -> float:
    """(private API)"""
    pass
# static inline float  ImAsinh(float x)  { return asinhf(x); }    /* original C++ signature */
@overload
def im_asinh(x: float) -> float:
    """(private API)"""
    pass
# static inline double ImAsinh(double x) { return asinh(x);  }    /* original C++ signature */
@overload
def im_asinh(x: float) -> float:
    """(private API)"""
    pass
# static inline int ImPosMod(int l, int r) { return (l % r + r) % r; }    /* original C++ signature */
def im_pos_mod(l: int, r: int) -> int:
    """ Returns always positive modulo (assumes r != 0)
    (private API)
    """
    pass
# static inline bool ImNan(double val) { return isnan(val); }    /* original C++ signature */
def im_nan(val: float) -> bool:
    """ Returns True if val is NAN
    (private API)
    """
    pass
# static inline bool ImNanOrInf(double val) { return !(val >= -DBL_MAX && val <= DBL_MAX) || ImNan(val); }    /* original C++ signature */
def im_nan_or_inf(val: float) -> bool:
    """ Returns True if val is NAN or INFINITY
    (private API)
    """
    pass
# static inline double ImConstrainNan(double val) { return ImNan(val) ? 0 : val; }    /* original C++ signature */
def im_constrain_nan(val: float) -> float:
    """ Turns NANs to 0s
    (private API)
    """
    pass
# static inline double ImConstrainInf(double val) { return val >= DBL_MAX ?  DBL_MAX : val <= -DBL_MAX ? - DBL_MAX : val; }    /* original C++ signature */
def im_constrain_inf(val: float) -> float:
    """ Turns infinity to floating point maximums
    (private API)
    """
    pass
# static inline double ImConstrainLog(double val) { return val <= 0 ? 0.001f : val; }    /* original C++ signature */
def im_constrain_log(val: float) -> float:
    """ Turns numbers less than or equal to 0 to 0.001 (sort of arbitrary, is there a better way?)
    (private API)
    """
    pass
# static inline double ImConstrainTime(double val) { return val < IMPLOT_MIN_TIME ? IMPLOT_MIN_TIME : (val > IMPLOT_MAX_TIME ? IMPLOT_MAX_TIME : val); }    /* original C++ signature */
def im_constrain_time(val: float) -> float:
    """ Turns numbers less than 0 to zero
    (private API)
    """
    pass
# static inline bool ImAlmostEqual(double v1, double v2, int ulp = 2) { return ImAbs(v1-v2) < DBL_EPSILON * ImAbs(v1+v2) * ulp || ImAbs(v1-v2) < DBL_MIN; }    /* original C++ signature */
def im_almost_equal(v1: float, v2: float, ulp: int = 2) -> bool:
    """ True if two numbers are approximately equal using units in the last place.
    (private API)
    """
    pass
# static inline ImU32 ImMixU32(ImU32 a, ImU32 b, ImU32 s) {    /* original C++ signature */
# #ifdef IMPLOT_MIX64
#     const ImU32 af = 256-s;
#     const ImU32 bf = s;
#     const ImU64 al = (a & 0x00ff00ff) | (((ImU64)(a & 0xff00ff00)) << 24);
#     const ImU64 bl = (b & 0x00ff00ff) | (((ImU64)(b & 0xff00ff00)) << 24);
#     const ImU64 mix = (al * af + bl * bf);
#     return ((mix >> 32) & 0xff00ff00) | ((mix & 0xff00ff00) >> 8);
# #else
#     const ImU32 af = 256-s;
#     const ImU32 bf = s;
#     const ImU32 al = (a & 0x00ff00ff);
#     const ImU32 ah = (a & 0xff00ff00) >> 8;
#     const ImU32 bl = (b & 0x00ff00ff);
#     const ImU32 bh = (b & 0xff00ff00) >> 8;
#     const ImU32 ml = (al * af + bl * bf);
#     const ImU32 mh = (ah * af + bh * bf);
#     return (mh & 0xff00ff00) | ((ml & 0xff00ff00) >> 8);
# #endif
# }
def im_mix_u32(a: ImU32, b: ImU32, s: ImU32) -> ImU32:
    """ Mix color a and b by factor s in [0 256]
    (private API)
    """
    pass

# static inline ImU32 ImLerpU32(const ImU32* colors, int size, float t) {    /* original C++ signature */
#     int i1 = (int)((size - 1 ) * t);
#     int i2 = i1 + 1;
#     if (i2 == size || size == 1)
#         return colors[i1];
#     float den = 1.0f / (size - 1);
#     float t1 = i1 * den;
#     float t2 = i2 * den;
#     float tr = ImRemap01(t, t1, t2);
#     return ImMixU32(colors[i1], colors[i2], (ImU32)(tr*256));
# }
def im_lerp_u32(colors: ImU32, size: int, t: float) -> ImU32:
    """ Lerp across an array of 32-bit collors given t in [0.0 1.0]
    (private API)
    """
    pass

# static inline ImU32 ImAlphaU32(ImU32 col, float alpha) {    /* original C++ signature */
#     return col & ~((ImU32)((1.0f-alpha)*255)<<IM_COL32_A_SHIFT);
# }
def im_alpha_u32(col: ImU32, alpha: float) -> ImU32:
    """ Set alpha channel of 32-bit color from float in range [0.0 1.0]
    (private API)
    """
    pass


#-----------------------------------------------------------------------------
# [SECTION] ImPlot Enums
#-----------------------------------------------------------------------------


class TimeUnit_(enum.Enum):
    # ImPlotTimeUnit_Us,      /* original C++ signature */
    us = enum.auto()    # (= 0)  # microsecond
    # ImPlotTimeUnit_Ms,      /* original C++ signature */
    ms = enum.auto()    # (= 1)  # millisecond
    # ImPlotTimeUnit_S,       /* original C++ signature */
    s = enum.auto()     # (= 2)  # second
    # ImPlotTimeUnit_Min,     /* original C++ signature */
    min = enum.auto()   # (= 3)  # minute
    # ImPlotTimeUnit_Hr,      /* original C++ signature */
    hr = enum.auto()    # (= 4)  # hour
    # ImPlotTimeUnit_Day,     /* original C++ signature */
    day = enum.auto()   # (= 5)  # day
    # ImPlotTimeUnit_Mo,      /* original C++ signature */
    mo = enum.auto()    # (= 6)  # month
    # ImPlotTimeUnit_Yr,      /* original C++ signature */
    yr = enum.auto()    # (= 7)  # year
    # ImPlotTimeUnit_COUNT    /* original C++ signature */
    # }
    count = enum.auto() # (= 8)

class DateFmt_(enum.Enum):
    # default        [ ISO 8601     ]
    # ImPlotDateFmt_None = 0,    /* original C++ signature */
    none = enum.auto()      # (= 0)
    # ImPlotDateFmt_DayMo,               /* original C++ signature */
    day_mo = enum.auto()    # (= 1)  # 10/3           [ --10-03      ]
    # ImPlotDateFmt_DayMoYr,             /* original C++ signature */
    day_mo_yr = enum.auto() # (= 2)  # 10/3/91        [ 1991-10-03   ]
    # ImPlotDateFmt_MoYr,                /* original C++ signature */
    mo_yr = enum.auto()     # (= 3)  # Oct 1991       [ 1991-10      ]
    # ImPlotDateFmt_Mo,                  /* original C++ signature */
    mo = enum.auto()        # (= 4)  # Oct            [ --10         ]
    # ImPlotDateFmt_Yr                   /* original C++ signature */
    yr = enum.auto()        # (= 5)  # 1991           [ 1991         ]

class TimeFmt_(enum.Enum):
    # default        [ 24 Hour Clock ]
    # ImPlotTimeFmt_None = 0,    /* original C++ signature */
    none = enum.auto()        # (= 0)
    # ImPlotTimeFmt_Us,                  /* original C++ signature */
    us = enum.auto()          # (= 1)  # .428 552       [ .428 552     ]
    # ImPlotTimeFmt_SUs,                 /* original C++ signature */
    s_us = enum.auto()        # (= 2)  # :29.428 552    [ :29.428 552  ]
    # ImPlotTimeFmt_SMs,                 /* original C++ signature */
    s_ms = enum.auto()        # (= 3)  # :29.428        [ :29.428      ]
    # ImPlotTimeFmt_S,                   /* original C++ signature */
    s = enum.auto()           # (= 4)  # :29            [ :29          ]
    # ImPlotTimeFmt_MinSMs,              /* original C++ signature */
    min_s_ms = enum.auto()    # (= 5)  # 21:29.428      [ 21:29.428    ]
    # ImPlotTimeFmt_HrMinSMs,            /* original C++ signature */
    hr_min_s_ms = enum.auto() # (= 6)  # 7:21:29.428pm  [ 19:21:29.428 ]
    # ImPlotTimeFmt_HrMinS,              /* original C++ signature */
    hr_min_s = enum.auto()    # (= 7)  # 7:21:29pm      [ 19:21:29     ]
    # ImPlotTimeFmt_HrMin,               /* original C++ signature */
    hr_min = enum.auto()      # (= 8)  # 7:21pm         [ 19:21        ]
    # ImPlotTimeFmt_Hr                   /* original C++ signature */
    hr = enum.auto()          # (= 9)  # 7pm            [ 19:00        ]

#-----------------------------------------------------------------------------
# [SECTION] Callbacks
#-----------------------------------------------------------------------------


#-----------------------------------------------------------------------------
# [SECTION] Structs
#-----------------------------------------------------------------------------

class DateTimeSpec:
    """ Combined date/time format spec"""
    # ImPlotDateTimeSpec() {}    /* original C++ signature */
    @overload
    def __init__(self) -> None:
        pass
    # ImPlotDateTimeSpec(ImPlotDateFmt date_fmt, ImPlotTimeFmt time_fmt, bool use_24_hr_clk = false, bool use_iso_8601 = false) {    /* original C++ signature */
    #         Date           = date_fmt;
    #         Time           = time_fmt;
    #         UseISO8601     = use_iso_8601;
    #         Use24HourClock = use_24_hr_clk;
    #     }
    @overload
    def __init__(self, date_fmt: DateFmt, time_fmt: TimeFmt, use_24_hr_clk: bool = False, use_iso_8601: bool = False) -> None:
        pass
    # ImPlotDateFmt Date;    /* original C++ signature */
    date: DateFmt
    # ImPlotTimeFmt Time;    /* original C++ signature */
    time: TimeFmt
    # bool UseISO8601;    /* original C++ signature */
    use_iso8601: bool
    # bool Use24HourClock;    /* original C++ signature */
    use24_hour_clock: bool

class Time:
    """ Two part timestamp struct."""
    # time_t S;    /* original C++ signature */
    s: time_t  # second part
    # int    Us;    /* original C++ signature */
    us: int    # microsecond part
    # ImPlotTime() { S = 0; Us = 0; }    /* original C++ signature */
    @overload
    def __init__(self) -> None:
        pass
    # ImPlotTime(time_t s, int us = 0) { S  = s + us / 1000000; Us = us % 1000000; }    /* original C++ signature */
    @overload
    def __init__(self, s: time_t, us: int = 0) -> None:
        pass
    # void RollOver() { S  = S + Us / 1000000;  Us = Us % 1000000; }    /* original C++ signature */
    def roll_over(self) -> None:
        """(private API)"""
        pass
    # double ToDouble() const { return (double)S + (double)Us / 1000000.0; }    /* original C++ signature */
    def to_double(self) -> float:
        """(private API)"""
        pass
    # static ImPlotTime FromDouble(double t) { return ImPlotTime((time_t)t, (int)(t * 1000000 - floor(t) * 1000000)); }    /* original C++ signature */
    @staticmethod
    def from_double(t: float) -> Time:
        """(private API)"""
        pass


class ColormapData:
    """ Colormap data storage"""
    # ImVector<ImU32> Keys;    /* original C++ signature */
    keys: ImVector_ImU32
    # ImVector<int>   KeyCounts;    /* original C++ signature */
    key_counts: ImVector_int
    # ImVector<int>   KeyOffsets;    /* original C++ signature */
    key_offsets: ImVector_int
    # ImVector<ImU32> Tables;    /* original C++ signature */
    tables: ImVector_ImU32
    # ImVector<int>   TableSizes;    /* original C++ signature */
    table_sizes: ImVector_int
    # ImVector<int>   TableOffsets;    /* original C++ signature */
    table_offsets: ImVector_int
    # ImGuiTextBuffer Text;    /* original C++ signature */
    text: TextBuffer
    # ImVector<int>   TextOffsets;    /* original C++ signature */
    text_offsets: ImVector_int
    # ImGuiStorage    Map;    /* original C++ signature */
    map: Storage
    # int             Count;    /* original C++ signature */
    count: int

    # ImPlotColormapData() { Count = 0; }    /* original C++ signature */
    def __init__(self) -> None:
        pass

    # int Append(const char* name, const ImU32* keys, int count, bool qual) {    /* original C++ signature */
    #         if (GetIndex(name) != -1)
    #             return -1;
    #         KeyOffsets.push_back(Keys.size());
    #         KeyCounts.push_back(count);
    #         Keys.reserve(Keys.size()+count);
    #         for (int i = 0; i < count; ++i)
    #             Keys.push_back(keys[i]);
    #         TextOffsets.push_back(Text.size());
    #         Text.append(name, name + strlen(name) + 1);
    #         Quals.push_back(qual);
    #         ImGuiID id = ImHashStr(name);
    #         int idx = Count++;
    #         Map.SetInt(id,idx);
    #         _AppendTable(idx);
    #         return idx;
    #     }
    def append(self, name: str, keys: ImU32, count: int, qual: bool) -> int:
        """(private API)"""
        pass

    # void _AppendTable(ImPlotColormap cmap) {    /* original C++ signature */
    #         int key_count     = GetKeyCount(cmap);
    #         const ImU32* keys = GetKeys(cmap);
    #         int off = Tables.size();
    #         TableOffsets.push_back(off);
    #         if (IsQual(cmap)) {
    #             Tables.reserve(key_count);
    #             for (int i = 0; i < key_count; ++i)
    #                 Tables.push_back(keys[i]);
    #             TableSizes.push_back(key_count);
    #         }
    #         else {
    #             int max_size = 255 * (key_count-1) + 1;
    #             Tables.reserve(off + max_size);
    #             // ImU32 last = keys[0];
    #             // Tables.push_back(last);
    #             // int n = 1;
    #             for (int i = 0; i < key_count-1; ++i) {
    #                 for (int s = 0; s < 255; ++s) {
    #                     ImU32 a = keys[i];
    #                     ImU32 b = keys[i+1];
    #                     ImU32 c = ImMixU32(a,b,s);
    #                     // if (c != last) {
    #                         Tables.push_back(c);
    #                         // last = c;
    #                         // n++;
    #                     // }
    #                 }
    #             }
    #             ImU32 c = keys[key_count-1];
    #             // if (c != last) {
    #                 Tables.push_back(c);
    #                 // n++;
    #             // }
    #             // TableSizes.push_back(n);
    #             TableSizes.push_back(max_size);
    #         }
    #     }
    def _append_table(self, cmap: Colormap) -> None:
        """(private API)"""
        pass

    # void RebuildTables() {    /* original C++ signature */
    #         Tables.resize(0);
    #         TableSizes.resize(0);
    #         TableOffsets.resize(0);
    #         for (int i = 0; i < Count; ++i)
    #             _AppendTable(i);
    #     }
    def rebuild_tables(self) -> None:
        """(private API)"""
        pass

    # inline bool           IsQual(ImPlotColormap cmap) const                      { return Quals[cmap];                                                }    /* original C++ signature */
    def is_qual(self, cmap: Colormap) -> bool:
        """(private API)"""
        pass
    # inline const char*    GetName(ImPlotColormap cmap) const                     { return cmap < Count ? Text.Buf.Data + TextOffsets[cmap] : nullptr; }    /* original C++ signature */
    def get_name(self, cmap: Colormap) -> str:
        """(private API)"""
        pass
    # inline ImPlotColormap GetIndex(const char* name) const                       { ImGuiID key = ImHashStr(name); return Map.GetInt(key,-1);          }    /* original C++ signature */
    def get_index(self, name: str) -> Colormap:
        """(private API)"""
        pass

    # inline const ImU32*   GetKeys(ImPlotColormap cmap) const                     { return &Keys[KeyOffsets[cmap]];                                    }    /* original C++ signature */
    def get_keys(self, cmap: Colormap) -> ImU32:
        """(private API)"""
        pass
    # inline int            GetKeyCount(ImPlotColormap cmap) const                 { return KeyCounts[cmap];                                            }    /* original C++ signature */
    def get_key_count(self, cmap: Colormap) -> int:
        """(private API)"""
        pass
    # inline ImU32          GetKeyColor(ImPlotColormap cmap, int idx) const        { return Keys[KeyOffsets[cmap]+idx];                                 }    /* original C++ signature */
    def get_key_color(self, cmap: Colormap, idx: int) -> ImU32:
        """(private API)"""
        pass
    # inline void           SetKeyColor(ImPlotColormap cmap, int idx, ImU32 value) { Keys[KeyOffsets[cmap]+idx] = value; RebuildTables();               }    /* original C++ signature */
    def set_key_color(self, cmap: Colormap, idx: int, value: ImU32) -> None:
        """(private API)"""
        pass

    # inline const ImU32*   GetTable(ImPlotColormap cmap) const                    { return &Tables[TableOffsets[cmap]];                                }    /* original C++ signature */
    def get_table(self, cmap: Colormap) -> ImU32:
        """(private API)"""
        pass
    # inline int            GetTableSize(ImPlotColormap cmap) const                { return TableSizes[cmap];                                           }    /* original C++ signature */
    def get_table_size(self, cmap: Colormap) -> int:
        """(private API)"""
        pass
    # inline ImU32          GetTableColor(ImPlotColormap cmap, int idx) const      { return Tables[TableOffsets[cmap]+idx];                             }    /* original C++ signature */
    def get_table_color(self, cmap: Colormap, idx: int) -> ImU32:
        """(private API)"""
        pass

    # inline ImU32 LerpTable(ImPlotColormap cmap, float t) const {    /* original C++ signature */
    #         int off = TableOffsets[cmap];
    #         int siz = TableSizes[cmap];
    #         int idx = Quals[cmap] ? ImClamp((int)(siz*t),0,siz-1) : (int)((siz - 1) * t + 0.5f);
    #         return Tables[off + idx];
    #     }
    def lerp_table(self, cmap: Colormap, t: float) -> ImU32:
        """(private API)"""
        pass

class PointError:
    """ ImPlotPoint with positive/negative error values"""
    # double X,     /* original C++ signature */
    x: float
    # Y,     /* original C++ signature */
    y: float
    # Neg,     /* original C++ signature */
    neg: float
    # Pos;    /* original C++ signature */
    pos: float
    # ImPlotPointError(double x, double y, double neg, double pos) {    /* original C++ signature */
    #         X = x; Y = y; Neg = neg; Pos = pos;
    #     }
    def __init__(self, x: float, y: float, neg: float, pos: float) -> None:
        pass

class Annotation:
    """ Interior plot label/annotation"""
    # ImVec2 Pos;    /* original C++ signature */
    pos: ImVec2
    # ImVec2 Offset;    /* original C++ signature */
    offset: ImVec2
    # ImU32  ColorBg;    /* original C++ signature */
    color_bg: ImU32
    # ImU32  ColorFg;    /* original C++ signature */
    color_fg: ImU32
    # int    TextOffset;    /* original C++ signature */
    text_offset: int
    # bool   Clamp;    /* original C++ signature */
    clamp: bool
    # ImPlotAnnotation() {    /* original C++ signature */
    #         ColorBg = ColorFg = 0;
    #         TextOffset = 0;
    #         Clamp = false;
    #     }
    def __init__(self) -> None:
        pass

class AnnotationCollection:
    """ Collection of plot labels"""

    # ImGuiTextBuffer            TextBuffer;    /* original C++ signature */
    text_buffer: TextBuffer
    # int                        Size;    /* original C++ signature */
    size: int

    # ImPlotAnnotationCollection() { Reset(); }    /* original C++ signature */
    def __init__(self) -> None:
        pass


    # void Append(const ImVec2& pos, const ImVec2& off, ImU32 bg, ImU32 fg, bool clamp, const char* fmt,  ...)  {    /* original C++ signature */
    #         va_list args;
    #         va_start(args, fmt);
    #         AppendV(pos, off, bg, fg, clamp, fmt, args);
    #         va_end(args);
    #     }
    def append(self, pos: ImVec2Like, off: ImVec2Like, bg: ImU32, fg: ImU32, clamp: bool, fmt: str) -> None:
        """(private API)"""
        pass

    # const char* GetText(int idx) {    /* original C++ signature */
    #         return TextBuffer.Buf.Data + Annotations[idx].TextOffset;
    #     }
    def get_text(self, idx: int) -> str:
        """(private API)"""
        pass

    # void Reset() {    /* original C++ signature */
    #         Annotations.shrink(0);
    #         TextBuffer.Buf.shrink(0);
    #         Size = 0;
    #     }
    def reset(self) -> None:
        """(private API)"""
        pass

class Tag:
    # ImAxis Axis;    /* original C++ signature */
    axis: ImAxis
    # double Value;    /* original C++ signature */
    value: float
    # ImU32  ColorBg;    /* original C++ signature */
    color_bg: ImU32
    # ImU32  ColorFg;    /* original C++ signature */
    color_fg: ImU32
    # int    TextOffset;    /* original C++ signature */
    text_offset: int
    # ImPlotTag(ImAxis Axis = ImAxis(), double Value = double(), ImU32 ColorBg = ImU32(), ImU32 ColorFg = ImU32(), int TextOffset = int());    /* original C++ signature */
    def __init__(self, axis: Optional[ImAxis] = None, value: float = float(), color_bg: ImU32 = ImU32(), color_fg: ImU32 = ImU32(), text_offset: int = int()) -> None:
        """Auto-generated default constructor with named params
        ---
        Python bindings defaults:
            If Axis is None, then its default value will be: ImAxis()
        """
        pass

class TagCollection:

    # ImGuiTextBuffer     TextBuffer;    /* original C++ signature */
    text_buffer: TextBuffer
    # int                 Size;    /* original C++ signature */
    size: int

    # ImPlotTagCollection() { Reset(); }    /* original C++ signature */
    def __init__(self) -> None:
        pass


    # void Append(ImAxis axis, double value, ImU32 bg, ImU32 fg, const char* fmt, ...)  {    /* original C++ signature */
    #         va_list args;
    #         va_start(args, fmt);
    #         AppendV(axis, value, bg, fg, fmt, args);
    #         va_end(args);
    #     }
    def append(self, axis: ImAxis, value: float, bg: ImU32, fg: ImU32, fmt: str) -> None:
        """(private API)"""
        pass

    # const char* GetText(int idx) {    /* original C++ signature */
    #         return TextBuffer.Buf.Data + Tags[idx].TextOffset;
    #     }
    def get_text(self, idx: int) -> str:
        """(private API)"""
        pass

    # void Reset() {    /* original C++ signature */
    #         Tags.shrink(0);
    #         TextBuffer.Buf.shrink(0);
    #         Size = 0;
    #     }
    def reset(self) -> None:
        """(private API)"""
        pass

class Tick:
    """ Tick mark info"""
    # double PlotPos;    /* original C++ signature */
    plot_pos: float
    # float  PixelPos;    /* original C++ signature */
    pixel_pos: float
    # ImVec2 LabelSize;    /* original C++ signature */
    label_size: ImVec2
    # int    TextOffset;    /* original C++ signature */
    text_offset: int
    # bool   Major;    /* original C++ signature */
    major: bool
    # bool   ShowLabel;    /* original C++ signature */
    show_label: bool
    # int    Level;    /* original C++ signature */
    level: int
    # int    Idx;    /* original C++ signature */
    idx: int

    # ImPlotTick(double value, bool major, int level, bool show_label) {    /* original C++ signature */
    #         PixelPos     = 0;
    #         PlotPos      = value;
    #         Major        = major;
    #         ShowLabel    = show_label;
    #         Level        = level;
    #         TextOffset   = -1;
    #     }
    def __init__(self, value: float, major: bool, level: int, show_label: bool) -> None:
        pass

class Ticker:
    """ Collection of ticks"""
    # ImGuiTextBuffer      TextBuffer;    /* original C++ signature */
    text_buffer: TextBuffer
    # ImVec2               MaxSize;    /* original C++ signature */
    max_size: ImVec2
    # ImVec2               LateSize;    /* original C++ signature */
    late_size: ImVec2
    # int                  Levels;    /* original C++ signature */
    levels: int

    # ImPlotTicker() {    /* original C++ signature */
    #         Reset();
    #     }
    def __init__(self) -> None:
        pass

    # ImPlotTick& AddTick(double value, bool major, int level, bool show_label, const char* label) {    /* original C++ signature */
    #         ImPlotTick tick(value, major, level, show_label);
    #         if (show_label && label != nullptr) {
    #             tick.TextOffset = TextBuffer.size();
    #             TextBuffer.append(label, label + strlen(label) + 1);
    #             tick.LabelSize = ImGui::CalcTextSize(TextBuffer.Buf.Data + tick.TextOffset);
    #         }
    #         return AddTick(tick);
    #     }
    @overload
    def add_tick(self, value: float, major: bool, level: int, show_label: bool, label: str) -> Tick:
        """(private API)"""
        pass


    # inline ImPlotTick& AddTick(ImPlotTick tick) {    /* original C++ signature */
    #         if (tick.ShowLabel) {
    #             MaxSize.x     =  tick.LabelSize.x > MaxSize.x ? tick.LabelSize.x : MaxSize.x;
    #             MaxSize.y     =  tick.LabelSize.y > MaxSize.y ? tick.LabelSize.y : MaxSize.y;
    #         }
    #         tick.Idx = Ticks.size();
    #         Ticks.push_back(tick);
    #         return Ticks.back();
    #     }
    @overload
    def add_tick(self, tick: Tick) -> Tick:
        """(private API)"""
        pass

    # const char* GetText(int idx) const {    /* original C++ signature */
    #         return TextBuffer.Buf.Data + Ticks[idx].TextOffset;
    #     }
    @overload
    def get_text(self, idx: int) -> str:
        """(private API)"""
        pass

    # const char* GetText(const ImPlotTick& tick) {    /* original C++ signature */
    #         return GetText(tick.Idx);
    #     }
    @overload
    def get_text(self, tick: Tick) -> str:
        """(private API)"""
        pass

    # void OverrideSizeLate(const ImVec2& size) {    /* original C++ signature */
    #         LateSize.x = size.x > LateSize.x ? size.x : LateSize.x;
    #         LateSize.y = size.y > LateSize.y ? size.y : LateSize.y;
    #     }
    def override_size_late(self, size: ImVec2Like) -> None:
        """(private API)"""
        pass

    # void Reset() {    /* original C++ signature */
    #         Ticks.shrink(0);
    #         TextBuffer.Buf.shrink(0);
    #         MaxSize = LateSize;
    #         LateSize = ImVec2(0,0);
    #         Levels = 1;
    #     }
    def reset(self) -> None:
        """(private API)"""
        pass

    # int TickCount() const {    /* original C++ signature */
    #         return Ticks.Size;
    #     }
    def tick_count(self) -> int:
        """(private API)"""
        pass

class Axis:
    """ Axis state information that must persist after EndPlot"""
    # ImGuiID              ID;    /* original C++ signature */
    id_: ID
    # ImPlotAxisFlags      Flags;    /* original C++ signature */
    flags: AxisFlags
    # ImPlotAxisFlags      PreviousFlags;    /* original C++ signature */
    previous_flags: AxisFlags
    # ImPlotRange          Range;    /* original C++ signature */
    range: Range
    # ImPlotCond           RangeCond;    /* original C++ signature */
    range_cond: Cond
    # ImPlotScale          Scale;    /* original C++ signature */
    scale: Scale
    # ImPlotRange          FitExtents;    /* original C++ signature */
    fit_extents: Range
    # ImPlotAxis*          OrthoAxis;    /* original C++ signature */
    ortho_axis: Axis
    # ImPlotRange          ConstraintRange;    /* original C++ signature */
    constraint_range: Range
    # ImPlotRange          ConstraintZoom;    /* original C++ signature */
    constraint_zoom: Range

    # ImPlotTicker         Ticker;    /* original C++ signature */
    ticker: Ticker
    # void*                FormatterData;    /* original C++ signature */
    formatter_data: Any

    # double*              LinkedMin;    /* original C++ signature */
    linked_min: float
    # double*              LinkedMax;    /* original C++ signature */
    linked_max: float

    # int                  PickerLevel;    /* original C++ signature */
    picker_level: int
    # ImPlotTime           PickerTimeMin,     /* original C++ signature */
    picker_time_min: Time
    # PickerTimeMax;    /* original C++ signature */
    picker_time_max: Time

    # void*                TransformData;    /* original C++ signature */
    transform_data: Any
    # float                PixelMin,     /* original C++ signature */
    pixel_min: float
    # PixelMax;    /* original C++ signature */
    pixel_max: float
    # double               ScaleMin,     /* original C++ signature */
    scale_min: float
    # ScaleMax;    /* original C++ signature */
    scale_max: float
    # double               ScaleToPixel;    /* original C++ signature */
    scale_to_pixel: float
    # float                Datum1,     /* original C++ signature */
    datum1: float
    # Datum2;    /* original C++ signature */
    datum2: float

    # ImRect               HoverRect;    /* original C++ signature */
    hover_rect: ImRect
    # int                  LabelOffset;    /* original C++ signature */
    label_offset: int
    # ImU32                ColorMaj,     /* original C++ signature */
    color_maj: ImU32
    # ColorMin,     /* original C++ signature */
    color_min: ImU32
    # ColorTick,     /* original C++ signature */
    color_tick: ImU32
    # ColorTxt,     /* original C++ signature */
    color_txt: ImU32
    # ColorBg,     /* original C++ signature */
    color_bg: ImU32
    # ColorHov,     /* original C++ signature */
    color_hov: ImU32
    # ColorAct,     /* original C++ signature */
    color_act: ImU32
    # ColorHiLi;    /* original C++ signature */
    color_hi_li: ImU32

    # bool                 Enabled;    /* original C++ signature */
    enabled: bool
    # bool                 Vertical;    /* original C++ signature */
    vertical: bool
    # bool                 FitThisFrame;    /* original C++ signature */
    fit_this_frame: bool
    # bool                 HasRange;    /* original C++ signature */
    has_range: bool
    # bool                 HasFormatSpec;    /* original C++ signature */
    has_format_spec: bool
    # bool                 ShowDefaultTicks;    /* original C++ signature */
    show_default_ticks: bool
    # bool                 Hovered;    /* original C++ signature */
    hovered: bool
    # bool                 Held;    /* original C++ signature */
    held: bool

    # ImPlotAxis() {    /* original C++ signature */
    #         ID               = 0;
    #         Flags            = PreviousFlags = ImPlotAxisFlags_None;
    #         Range.Min        = 0;
    #         Range.Max        = 1;
    #         Scale            = ImPlotScale_Linear;
    #         TransformForward = TransformInverse = nullptr;
    #         TransformData    = nullptr;
    #         FitExtents.Min   = HUGE_VAL;
    #         FitExtents.Max   = -HUGE_VAL;
    #         OrthoAxis        = nullptr;
    #         ConstraintRange  = ImPlotRange(-INFINITY,INFINITY);
    #         ConstraintZoom   = ImPlotRange(DBL_MIN,INFINITY);
    #         LinkedMin        = LinkedMax = nullptr;
    #         PickerLevel      = 0;
    #         Datum1           = Datum2 = 0;
    #         PixelMin         = PixelMax = 0;
    #         LabelOffset      = -1;
    #         ColorMaj         = ColorMin = ColorTick = ColorTxt = ColorBg = ColorHov = ColorAct = 0;
    #         ColorHiLi        = IM_COL32_BLACK_TRANS;
    #         Formatter        = nullptr;
    #         FormatterData    = nullptr;
    #         Locator          = nullptr;
    #         Enabled          = Hovered = Held = FitThisFrame = HasRange = HasFormatSpec = false;
    #         ShowDefaultTicks = true;
    #     }
    def __init__(self) -> None:
        pass

    # inline void Reset() {    /* original C++ signature */
    #         Enabled          = false;
    #         Scale            = ImPlotScale_Linear;
    #         TransformForward = TransformInverse = nullptr;
    #         TransformData    = nullptr;
    #         LabelOffset      = -1;
    #         HasFormatSpec    = false;
    #         Formatter        = nullptr;
    #         FormatterData    = nullptr;
    #         Locator          = nullptr;
    #         ShowDefaultTicks = true;
    #         FitThisFrame     = false;
    #         FitExtents.Min   = HUGE_VAL;
    #         FitExtents.Max   = -HUGE_VAL;
    #         OrthoAxis        = nullptr;
    #         ConstraintRange  = ImPlotRange(-INFINITY,INFINITY);
    #         ConstraintZoom   = ImPlotRange(DBL_MIN,INFINITY);
    #         Ticker.Reset();
    #     }
    def reset(self) -> None:
        """(private API)"""
        pass

    # inline bool SetMin(double _min, bool force=false) {    /* original C++ signature */
    #         if (!force && IsLockedMin())
    #             return false;
    #         _min = ImConstrainNan(ImConstrainInf(_min));
    #         if (_min < ConstraintRange.Min)
    #             _min = ConstraintRange.Min;
    #         double z = Range.Max - _min;
    #         if (z < ConstraintZoom.Min)
    #             _min = Range.Max - ConstraintZoom.Min;
    #         if (z > ConstraintZoom.Max)
    #             _min = Range.Max - ConstraintZoom.Max;
    #         if (_min >= Range.Max)
    #             return false;
    #         Range.Min = _min;
    #         PickerTimeMin = ImPlotTime::FromDouble(Range.Min);
    #         UpdateTransformCache();
    #         return true;
    #     }
    def set_min(self, _min: float, force: bool = False) -> bool:
        """(private API)"""
        pass

    # inline bool SetMax(double _max, bool force=false) {    /* original C++ signature */
    #         if (!force && IsLockedMax())
    #             return false;
    #         _max = ImConstrainNan(ImConstrainInf(_max));
    #         if (_max > ConstraintRange.Max)
    #             _max = ConstraintRange.Max;
    #         double z = _max - Range.Min;
    #         if (z < ConstraintZoom.Min)
    #             _max = Range.Min + ConstraintZoom.Min;
    #         if (z > ConstraintZoom.Max)
    #             _max = Range.Min + ConstraintZoom.Max;
    #         if (_max <= Range.Min)
    #             return false;
    #         Range.Max = _max;
    #         PickerTimeMax = ImPlotTime::FromDouble(Range.Max);
    #         UpdateTransformCache();
    #         return true;
    #     }
    def set_max(self, _max: float, force: bool = False) -> bool:
        """(private API)"""
        pass

    # inline void SetRange(double v1, double v2) {    /* original C++ signature */
    #         Range.Min = ImMin(v1,v2);
    #         Range.Max = ImMax(v1,v2);
    #         Constrain();
    #         PickerTimeMin = ImPlotTime::FromDouble(Range.Min);
    #         PickerTimeMax = ImPlotTime::FromDouble(Range.Max);
    #         UpdateTransformCache();
    #     }
    @overload
    def set_range(self, v1: float, v2: float) -> None:
        """(private API)"""
        pass

    # inline void SetRange(const ImPlotRange& range) {    /* original C++ signature */
    #         SetRange(range.Min, range.Max);
    #     }
    @overload
    def set_range(self, range: Range) -> None:
        """(private API)"""
        pass

    # inline void SetAspect(double unit_per_pix) {    /* original C++ signature */
    #         double new_size = unit_per_pix * PixelSize();
    #         double delta    = (new_size - Range.Size()) * 0.5;
    #         if (IsLocked())
    #             return;
    #         else if (IsLockedMin() && !IsLockedMax())
    #             SetRange(Range.Min, Range.Max  + 2*delta);
    #         else if (!IsLockedMin() && IsLockedMax())
    #             SetRange(Range.Min - 2*delta, Range.Max);
    #         else
    #             SetRange(Range.Min - delta, Range.Max + delta);
    #     }
    def set_aspect(self, unit_per_pix: float) -> None:
        """(private API)"""
        pass

    # inline float PixelSize() const { return ImAbs(PixelMax - PixelMin); }    /* original C++ signature */
    def pixel_size(self) -> float:
        """(private API)"""
        pass

    # inline double GetAspect() const { return Range.Size() / PixelSize(); }    /* original C++ signature */
    def get_aspect(self) -> float:
        """(private API)"""
        pass

    # inline void Constrain() {    /* original C++ signature */
    #         Range.Min = ImConstrainNan(ImConstrainInf(Range.Min));
    #         Range.Max = ImConstrainNan(ImConstrainInf(Range.Max));
    #         if (Range.Min < ConstraintRange.Min)
    #             Range.Min = ConstraintRange.Min;
    #         if (Range.Max > ConstraintRange.Max)
    #             Range.Max = ConstraintRange.Max;
    #         double z = Range.Size();
    #         if (z < ConstraintZoom.Min) {
    #             double delta = (ConstraintZoom.Min - z) * 0.5;
    #             Range.Min -= delta;
    #             Range.Max += delta;
    #         }
    #         if (z > ConstraintZoom.Max) {
    #             double delta = (z - ConstraintZoom.Max) * 0.5;
    #             Range.Min += delta;
    #             Range.Max -= delta;
    #         }
    #         if (Range.Max <= Range.Min)
    #             Range.Max = Range.Min + DBL_EPSILON;
    #     }
    def constrain(self) -> None:
        """(private API)"""
        pass

    # inline void UpdateTransformCache() {    /* original C++ signature */
    #         ScaleToPixel = (PixelMax - PixelMin) / Range.Size();
    #         if (TransformForward != nullptr) {
    #             ScaleMin = TransformForward(Range.Min, TransformData);
    #             ScaleMax = TransformForward(Range.Max, TransformData);
    #         }
    #         else {
    #             ScaleMin = Range.Min;
    #             ScaleMax = Range.Max;
    #         }
    #     }
    def update_transform_cache(self) -> None:
        """(private API)"""
        pass

    # inline float PlotToPixels(double plt) const {    /* original C++ signature */
    #         if (TransformForward != nullptr) {
    #             double s = TransformForward(plt, TransformData);
    #             double t = (s - ScaleMin) / (ScaleMax - ScaleMin);
    #             plt      = Range.Min + Range.Size() * t;
    #         }
    #         return (float)(PixelMin + ScaleToPixel * (plt - Range.Min));
    #     }
    def plot_to_pixels(self, plt: float) -> float:
        """(private API)"""
        pass


    # inline double PixelsToPlot(float pix) const {    /* original C++ signature */
    #         double plt = (pix - PixelMin) / ScaleToPixel + Range.Min;
    #         if (TransformInverse != nullptr) {
    #             double t = (plt - Range.Min) / Range.Size();
    #             double s = t * (ScaleMax - ScaleMin) + ScaleMin;
    #             plt = TransformInverse(s, TransformData);
    #         }
    #         return plt;
    #     }
    def pixels_to_plot(self, pix: float) -> float:
        """(private API)"""
        pass

    # inline void ExtendFit(double v) {    /* original C++ signature */
    #         if (!ImNanOrInf(v) && v >= ConstraintRange.Min && v <= ConstraintRange.Max) {
    #             FitExtents.Min = v < FitExtents.Min ? v : FitExtents.Min;
    #             FitExtents.Max = v > FitExtents.Max ? v : FitExtents.Max;
    #         }
    #     }
    def extend_fit(self, v: float) -> None:
        """(private API)"""
        pass

    # inline void ExtendFitWith(ImPlotAxis& alt, double v, double v_alt) {    /* original C++ signature */
    #         if (ImHasFlag(Flags, ImPlotAxisFlags_RangeFit) && !alt.Range.Contains(v_alt))
    #             return;
    #         if (!ImNanOrInf(v) && v >= ConstraintRange.Min && v <= ConstraintRange.Max) {
    #             FitExtents.Min = v < FitExtents.Min ? v : FitExtents.Min;
    #             FitExtents.Max = v > FitExtents.Max ? v : FitExtents.Max;
    #         }
    #     }
    def extend_fit_with(self, alt: Axis, v: float, v_alt: float) -> None:
        """(private API)"""
        pass

    # inline void ApplyFit(float padding) {    /* original C++ signature */
    #         const double ext_size = FitExtents.Size() * 0.5;
    #         FitExtents.Min -= ext_size * padding;
    #         FitExtents.Max += ext_size * padding;
    #         if (!IsLockedMin() && !ImNanOrInf(FitExtents.Min))
    #             Range.Min = FitExtents.Min;
    #         if (!IsLockedMax() && !ImNanOrInf(FitExtents.Max))
    #             Range.Max = FitExtents.Max;
    #         if (ImAlmostEqual(Range.Min, Range.Max))  {
    #             Range.Max += 0.5;
    #             Range.Min -= 0.5;
    #         }
    #         Constrain();
    #         UpdateTransformCache();
    #     }
    def apply_fit(self, padding: float) -> None:
        """(private API)"""
        pass

    # inline bool HasLabel()          const { return LabelOffset != -1 && !ImHasFlag(Flags, ImPlotAxisFlags_NoLabel);                          }    /* original C++ signature */
    def has_label(self) -> bool:
        """(private API)"""
        pass
    # inline bool HasGridLines()      const { return !ImHasFlag(Flags, ImPlotAxisFlags_NoGridLines);                                           }    /* original C++ signature */
    def has_grid_lines(self) -> bool:
        """(private API)"""
        pass
    # inline bool HasTickLabels()     const { return !ImHasFlag(Flags, ImPlotAxisFlags_NoTickLabels);                                          }    /* original C++ signature */
    def has_tick_labels(self) -> bool:
        """(private API)"""
        pass
    # inline bool HasTickMarks()      const { return !ImHasFlag(Flags, ImPlotAxisFlags_NoTickMarks);                                           }    /* original C++ signature */
    def has_tick_marks(self) -> bool:
        """(private API)"""
        pass
    # inline bool WillRender()        const { return Enabled && (HasGridLines() || HasTickLabels() || HasTickMarks());                         }    /* original C++ signature */
    def will_render(self) -> bool:
        """(private API)"""
        pass
    # inline bool IsOpposite()        const { return ImHasFlag(Flags, ImPlotAxisFlags_Opposite);                                               }    /* original C++ signature */
    def is_opposite(self) -> bool:
        """(private API)"""
        pass
    # inline bool IsInverted()        const { return ImHasFlag(Flags, ImPlotAxisFlags_Invert);                                                 }    /* original C++ signature */
    def is_inverted(self) -> bool:
        """(private API)"""
        pass
    # inline bool IsForeground()      const { return ImHasFlag(Flags, ImPlotAxisFlags_Foreground);                                             }    /* original C++ signature */
    def is_foreground(self) -> bool:
        """(private API)"""
        pass
    # inline bool IsAutoFitting()     const { return ImHasFlag(Flags, ImPlotAxisFlags_AutoFit);                                                }    /* original C++ signature */
    def is_auto_fitting(self) -> bool:
        """(private API)"""
        pass
    # inline bool CanInitFit()        const { return !ImHasFlag(Flags, ImPlotAxisFlags_NoInitialFit) && !HasRange && !LinkedMin && !LinkedMax; }    /* original C++ signature */
    def can_init_fit(self) -> bool:
        """(private API)"""
        pass
    # inline bool IsRangeLocked()     const { return HasRange && RangeCond == ImPlotCond_Always;                                               }    /* original C++ signature */
    def is_range_locked(self) -> bool:
        """(private API)"""
        pass
    # inline bool IsLockedMin()       const { return !Enabled || IsRangeLocked() || ImHasFlag(Flags, ImPlotAxisFlags_LockMin);                 }    /* original C++ signature */
    def is_locked_min(self) -> bool:
        """(private API)"""
        pass
    # inline bool IsLockedMax()       const { return !Enabled || IsRangeLocked() || ImHasFlag(Flags, ImPlotAxisFlags_LockMax);                 }    /* original C++ signature */
    def is_locked_max(self) -> bool:
        """(private API)"""
        pass
    # inline bool IsLocked()          const { return IsLockedMin() && IsLockedMax();                                                           }    /* original C++ signature */
    def is_locked(self) -> bool:
        """(private API)"""
        pass
    # inline bool IsInputLockedMin()  const { return IsLockedMin() || IsAutoFitting();                                                         }    /* original C++ signature */
    def is_input_locked_min(self) -> bool:
        """(private API)"""
        pass
    # inline bool IsInputLockedMax()  const { return IsLockedMax() || IsAutoFitting();                                                         }    /* original C++ signature */
    def is_input_locked_max(self) -> bool:
        """(private API)"""
        pass
    # inline bool IsInputLocked()     const { return IsLocked()    || IsAutoFitting();                                                         }    /* original C++ signature */
    def is_input_locked(self) -> bool:
        """(private API)"""
        pass
    # inline bool HasMenus()          const { return !ImHasFlag(Flags, ImPlotAxisFlags_NoMenus);                                               }    /* original C++ signature */
    def has_menus(self) -> bool:
        """(private API)"""
        pass

    # inline bool IsPanLocked(bool increasing) {    /* original C++ signature */
    #         if (ImHasFlag(Flags, ImPlotAxisFlags_PanStretch)) {
    #             return IsInputLocked();
    #         }
    #         else {
    #             if (IsLockedMin() || IsLockedMax() || IsAutoFitting())
    #                 return false;
    #             if (increasing)
    #                 return Range.Max == ConstraintRange.Max;
    #             else
    #                 return Range.Min == ConstraintRange.Min;
    #         }
    #     }
    def is_pan_locked(self, increasing: bool) -> bool:
        """(private API)"""
        pass

    # void PushLinks() {    /* original C++ signature */
    #         if (LinkedMin) { *LinkedMin = Range.Min; }
    #         if (LinkedMax) { *LinkedMax = Range.Max; }
    #     }
    def push_links(self) -> None:
        """(private API)"""
        pass

    # void PullLinks() {    /* original C++ signature */
    #         if (LinkedMin && LinkedMax) { SetRange(*LinkedMin, *LinkedMax); }
    #         else if (LinkedMin) { SetMin(*LinkedMin,true); }
    #         else if (LinkedMax) { SetMax(*LinkedMax,true); }
    #     }
    def pull_links(self) -> None:
        """(private API)"""
        pass

class AlignmentData:
    """ Align plots group data"""
    # bool  Vertical;    /* original C++ signature */
    vertical: bool
    # float PadA;    /* original C++ signature */
    pad_a: float
    # float PadB;    /* original C++ signature */
    pad_b: float
    # float PadAMax;    /* original C++ signature */
    pad_a_max: float
    # float PadBMax;    /* original C++ signature */
    pad_b_max: float
    # ImPlotAlignmentData() {    /* original C++ signature */
    #         Vertical    = true;
    #         PadA = PadB = PadAMax = PadBMax = 0;
    #     }
    def __init__(self) -> None:
        pass
    # void Begin() { PadAMax = PadBMax = 0; }    /* original C++ signature */
    def begin(self) -> None:
        """(private API)"""
        pass
    # void Update(float& pad_a, float& pad_b, float& delta_a, float& delta_b) {    /* original C++ signature */
    #         float bak_a = pad_a; float bak_b = pad_b;
    #         if (PadAMax < pad_a) { PadAMax = pad_a; }
    #         if (PadBMax < pad_b) { PadBMax = pad_b; }
    #         if (pad_a < PadA)    { pad_a = PadA; delta_a = pad_a - bak_a; } else { delta_a = 0; }
    #         if (pad_b < PadB)    { pad_b = PadB; delta_b = pad_b - bak_b; } else { delta_b = 0; }
    #     }
    def update(self, pad_a: float, pad_b: float, delta_a: float, delta_b: float) -> Tuple[float, float, float, float]:
        """(private API)"""
        pass
    # void End()   { PadA = PadAMax; PadB = PadBMax;      }    /* original C++ signature */
    def end(self) -> None:
        """(private API)"""
        pass
    # void Reset() { PadA = PadB = PadAMax = PadBMax = 0; }    /* original C++ signature */
    def reset(self) -> None:
        """(private API)"""
        pass

class Item:
    """ State information for Plot items"""
    # ImGuiID      ID;    /* original C++ signature */
    id_: ID
    # ImU32        Color;    /* original C++ signature */
    color: ImU32
    # ImRect       LegendHoverRect;    /* original C++ signature */
    legend_hover_rect: ImRect
    # int          NameOffset;    /* original C++ signature */
    name_offset: int
    # bool         Show;    /* original C++ signature */
    show: bool
    # bool         LegendHovered;    /* original C++ signature */
    legend_hovered: bool
    # bool         SeenThisFrame;    /* original C++ signature */
    seen_this_frame: bool

    # ImPlotItem() {    /* original C++ signature */
    #         ID            = 0;
    #         Color         = IM_COL32_WHITE;
    #         NameOffset    = -1;
    #         Show          = true;
    #         SeenThisFrame = false;
    #         LegendHovered = false;
    #     }
    def __init__(self) -> None:
        pass


class Legend:
    """ Holds Legend state"""
    # ImPlotLegendFlags Flags;    /* original C++ signature */
    flags: LegendFlags
    # ImPlotLegendFlags PreviousFlags;    /* original C++ signature */
    previous_flags: LegendFlags
    # ImPlotLocation    Location;    /* original C++ signature */
    location: Location
    # ImPlotLocation    PreviousLocation;    /* original C++ signature */
    previous_location: Location
    # ImVec2            Scroll;    /* original C++ signature */
    scroll: ImVec2
    # ImVector<int>     Indices;    /* original C++ signature */
    indices: ImVector_int
    # ImGuiTextBuffer   Labels;    /* original C++ signature */
    labels: TextBuffer
    # ImRect            Rect;    /* original C++ signature */
    rect: ImRect
    # ImRect            RectClamped;    /* original C++ signature */
    rect_clamped: ImRect
    # bool              Hovered;    /* original C++ signature */
    hovered: bool
    # bool              Held;    /* original C++ signature */
    held: bool
    # bool              CanGoInside;    /* original C++ signature */
    can_go_inside: bool

    # ImPlotLegend() {    /* original C++ signature */
    #         Flags        = PreviousFlags = ImPlotLegendFlags_None;
    #         CanGoInside  = true;
    #         Hovered      = Held = false;
    #         Location     = PreviousLocation = ImPlotLocation_NorthWest;
    #         Scroll       = ImVec2(0,0);
    #     }
    def __init__(self) -> None:
        pass

    # void Reset() { Indices.shrink(0); Labels.Buf.shrink(0); }    /* original C++ signature */
    def reset(self) -> None:
        """(private API)"""
        pass

class ItemGroup:
    """ Holds Items and Legend data"""
    # ImGuiID            ID;    /* original C++ signature */
    id_: ID
    # ImPlotLegend       Legend;    /* original C++ signature */
    legend: Legend
    # int                ColormapIdx;    /* original C++ signature */
    colormap_idx: int

    # ImPlotItemGroup() { ID = 0; ColormapIdx = 0; }    /* original C++ signature */
    def __init__(self) -> None:
        pass

    # int         GetItemCount() const             { return ItemPool.GetBufSize();                                 }    /* original C++ signature */
    def get_item_count(self) -> int:
        """(private API)"""
        pass
    # ImGuiID     GetItemID(const char*  label_id) { return ImGui::GetID(label_id); /* GetIDWithSeed */            }    /* original C++ signature */
    def get_item_id(self, label_id: str) -> ID:
        """(private API)"""
        pass
    # ImPlotItem* GetItem(ImGuiID id)              { return ItemPool.GetByKey(id);                                 }    /* original C++ signature */
    @overload
    def get_item(self, id_: ID) -> Item:
        """(private API)"""
        pass
    # ImPlotItem* GetItem(const char* label_id)    { return GetItem(GetItemID(label_id));                          }    /* original C++ signature */
    @overload
    def get_item(self, label_id: str) -> Item:
        """(private API)"""
        pass
    # ImPlotItem* GetOrAddItem(ImGuiID id)         { return ItemPool.GetOrAddByKey(id);                            }    /* original C++ signature */
    def get_or_add_item(self, id_: ID) -> Item:
        """(private API)"""
        pass
    # ImPlotItem* GetItemByIndex(int i)            { return ItemPool.GetByIndex(i);                                }    /* original C++ signature */
    def get_item_by_index(self, i: int) -> Item:
        """(private API)"""
        pass
    # int         GetItemIndex(ImPlotItem* item)   { return ItemPool.GetIndex(item);                               }    /* original C++ signature */
    def get_item_index(self, item: Item) -> int:
        """(private API)"""
        pass
    # int         GetLegendCount() const           { return Legend.Indices.size();                                 }    /* original C++ signature */
    def get_legend_count(self) -> int:
        """(private API)"""
        pass
    # ImPlotItem* GetLegendItem(int i)             { return ItemPool.GetByIndex(Legend.Indices[i]);                }    /* original C++ signature */
    def get_legend_item(self, i: int) -> Item:
        """(private API)"""
        pass
    # const char* GetLegendLabel(int i)            { return Legend.Labels.Buf.Data + GetLegendItem(i)->NameOffset; }    /* original C++ signature */
    def get_legend_label(self, i: int) -> str:
        """(private API)"""
        pass
    # void        Reset()                          { ItemPool.Clear(); Legend.Reset(); ColormapIdx = 0;            }    /* original C++ signature */
    def reset(self) -> None:
        """(private API)"""
        pass

class Plot:
    """ Holds Plot state information that must persist after EndPlot"""
    # ImGuiID              ID;    /* original C++ signature */
    id_: ID
    # ImPlotFlags          Flags;    /* original C++ signature */
    flags: Flags
    # ImPlotFlags          PreviousFlags;    /* original C++ signature */
    previous_flags: Flags
    # ImPlotLocation       MouseTextLocation;    /* original C++ signature */
    mouse_text_location: Location
    # ImPlotMouseTextFlags MouseTextFlags;    /* original C++ signature */
    mouse_text_flags: MouseTextFlags
    # ImGuiTextBuffer      TextBuffer;    /* original C++ signature */
    text_buffer: TextBuffer
    # ImPlotItemGroup      Items;    /* original C++ signature */
    items: ItemGroup
    # ImAxis               CurrentX;    /* original C++ signature */
    current_x: ImAxis
    # ImAxis               CurrentY;    /* original C++ signature */
    current_y: ImAxis
    # ImRect               FrameRect;    /* original C++ signature */
    frame_rect: ImRect
    # ImRect               CanvasRect;    /* original C++ signature */
    canvas_rect: ImRect
    # ImRect               PlotRect;    /* original C++ signature */
    plot_rect: ImRect
    # ImRect               AxesRect;    /* original C++ signature */
    axes_rect: ImRect
    # ImRect               SelectRect;    /* original C++ signature */
    select_rect: ImRect
    # ImVec2               SelectStart;    /* original C++ signature */
    select_start: ImVec2
    # int                  TitleOffset;    /* original C++ signature */
    title_offset: int
    # bool                 JustCreated;    /* original C++ signature */
    just_created: bool
    # bool                 Initialized;    /* original C++ signature */
    initialized: bool
    # bool                 SetupLocked;    /* original C++ signature */
    setup_locked: bool
    # bool                 FitThisFrame;    /* original C++ signature */
    fit_this_frame: bool
    # bool                 Hovered;    /* original C++ signature */
    hovered: bool
    # bool                 Held;    /* original C++ signature */
    held: bool
    # bool                 Selecting;    /* original C++ signature */
    selecting: bool
    # bool                 Selected;    /* original C++ signature */
    selected: bool
    # bool                 ContextLocked;    /* original C++ signature */
    context_locked: bool

    # ImPlotPlot() {    /* original C++ signature */
    #         Flags             = PreviousFlags = ImPlotFlags_None;
    #         for (int i = 0; i < IMPLOT_NUM_X_AXES; ++i)
    #             XAxis(i).Vertical = false;
    #         for (int i = 0; i < IMPLOT_NUM_Y_AXES; ++i)
    #             YAxis(i).Vertical = true;
    #         SelectStart       = ImVec2(0,0);
    #         CurrentX          = ImAxis_X1;
    #         CurrentY          = ImAxis_Y1;
    #         MouseTextLocation  = ImPlotLocation_South | ImPlotLocation_East;
    #         MouseTextFlags     = ImPlotMouseTextFlags_None;
    #         TitleOffset       = -1;
    #         JustCreated       = true;
    #         Initialized = SetupLocked = FitThisFrame = false;
    #         Hovered = Held = Selected = Selecting = ContextLocked = false;
    #     }
    def __init__(self) -> None:
        pass

    # inline bool IsInputLocked() const {    /* original C++ signature */
    #         for (int i = 0; i < IMPLOT_NUM_X_AXES; ++i) {
    #             if (!XAxis(i).IsInputLocked())
    #                 return false;
    #         }
    #         for (int i = 0; i < IMPLOT_NUM_Y_AXES; ++i) {
    #             if (!YAxis(i).IsInputLocked())
    #                 return false;
    #         }
    #         return true;
    #     }
    def is_input_locked(self) -> bool:
        """(private API)"""
        pass

    # inline void ClearTextBuffer() { TextBuffer.Buf.shrink(0); }    /* original C++ signature */
    def clear_text_buffer(self) -> None:
        """(private API)"""
        pass

    # inline void SetTitle(const char* title) {    /* original C++ signature */
    #         if (title && ImGui::FindRenderedTextEnd(title, nullptr) != title) {
    #             TitleOffset = TextBuffer.size();
    #             TextBuffer.append(title, title + strlen(title) + 1);
    #         }
    #         else {
    #             TitleOffset = -1;
    #         }
    #     }
    def set_title(self, title: str) -> None:
        """(private API)"""
        pass
    # inline bool HasTitle() const { return TitleOffset != -1 && !ImHasFlag(Flags, ImPlotFlags_NoTitle); }    /* original C++ signature */
    def has_title(self) -> bool:
        """(private API)"""
        pass
    # inline const char* GetTitle() const { return TextBuffer.Buf.Data + TitleOffset; }    /* original C++ signature */
    def get_title(self) -> str:
        """(private API)"""
        pass

    # inline       ImPlotAxis& XAxis(int i)       { return Axes[ImAxis_X1 + i]; }    /* original C++ signature */
    @overload
    def x_axis(self, i: int) -> Axis:
        """(private API)"""
        pass
    # inline const ImPlotAxis& XAxis(int i) const { return Axes[ImAxis_X1 + i]; }    /* original C++ signature */
    @overload
    def x_axis(self, i: int) -> Axis:
        """(private API)"""
        pass
    # inline       ImPlotAxis& YAxis(int i)       { return Axes[ImAxis_Y1 + i]; }    /* original C++ signature */
    @overload
    def y_axis(self, i: int) -> Axis:
        """(private API)"""
        pass
    # inline const ImPlotAxis& YAxis(int i) const { return Axes[ImAxis_Y1 + i]; }    /* original C++ signature */
    @overload
    def y_axis(self, i: int) -> Axis:
        """(private API)"""
        pass

    # inline int EnabledAxesX() {    /* original C++ signature */
    #         int cnt = 0;
    #         for (int i = 0; i < IMPLOT_NUM_X_AXES; ++i)
    #             cnt += XAxis(i).Enabled;
    #         return cnt;
    #     }
    def enabled_axes_x(self) -> int:
        """(private API)"""
        pass

    # inline int EnabledAxesY() {    /* original C++ signature */
    #         int cnt = 0;
    #         for (int i = 0; i < IMPLOT_NUM_Y_AXES; ++i)
    #             cnt += YAxis(i).Enabled;
    #         return cnt;
    #     }
    def enabled_axes_y(self) -> int:
        """(private API)"""
        pass

    # inline void SetAxisLabel(ImPlotAxis& axis, const char* label) {    /* original C++ signature */
    #         if (label && ImGui::FindRenderedTextEnd(label, nullptr) != label) {
    #             axis.LabelOffset = TextBuffer.size();
    #             TextBuffer.append(label, label + strlen(label) + 1);
    #         }
    #         else {
    #             axis.LabelOffset = -1;
    #         }
    #     }
    def set_axis_label(self, axis: Axis, label: str) -> None:
        """(private API)"""
        pass

    # inline const char* GetAxisLabel(const ImPlotAxis& axis) const { return TextBuffer.Buf.Data + axis.LabelOffset; }    /* original C++ signature */
    def get_axis_label(self, axis: Axis) -> str:
        """(private API)"""
        pass

class Subplot:
    """ Holds subplot data that must persist after EndSubplot"""
    # ImGuiID                       ID;    /* original C++ signature */
    id_: ID
    # ImPlotSubplotFlags            Flags;    /* original C++ signature */
    flags: SubplotFlags
    # ImPlotSubplotFlags            PreviousFlags;    /* original C++ signature */
    previous_flags: SubplotFlags
    # ImPlotItemGroup               Items;    /* original C++ signature */
    items: ItemGroup
    # int                           Rows;    /* original C++ signature */
    rows: int
    # int                           Cols;    /* original C++ signature */
    cols: int
    # int                           CurrentIdx;    /* original C++ signature */
    current_idx: int
    # ImRect                        FrameRect;    /* original C++ signature */
    frame_rect: ImRect
    # ImRect                        GridRect;    /* original C++ signature */
    grid_rect: ImRect
    # ImVec2                        CellSize;    /* original C++ signature */
    cell_size: ImVec2
    # ImVector<float>               RowRatios;    /* original C++ signature */
    row_ratios: ImVector_float
    # ImVector<float>               ColRatios;    /* original C++ signature */
    col_ratios: ImVector_float
    # float                         TempSizes[2];    /* original C++ signature */
    temp_sizes: np.ndarray  # ndarray[type=float, size=2]
    # bool                          FrameHovered;    /* original C++ signature */
    frame_hovered: bool
    # bool                          HasTitle;    /* original C++ signature */
    has_title: bool

    # ImPlotSubplot() {    /* original C++ signature */
    #         ID                          = 0;
    #         Flags = PreviousFlags       = ImPlotSubplotFlags_None;
    #         Rows = Cols = CurrentIdx    = 0;
    #         Items.Legend.Location       = ImPlotLocation_North;
    #         Items.Legend.Flags          = ImPlotLegendFlags_Horizontal|ImPlotLegendFlags_Outside;
    #         Items.Legend.CanGoInside    = false;
    #         TempSizes[0] = TempSizes[1] = 0;
    #         FrameHovered                = false;
    #         HasTitle                    = false;
    #     }
    def __init__(self) -> None:
        pass

class NextPlotData:
    """ Temporary data storage for upcoming plot"""

    # ImPlotNextPlotData() { Reset(); }    /* original C++ signature */
    def __init__(self) -> None:
        pass

    # void Reset() {    /* original C++ signature */
    #         for (int i = 0; i < ImAxis_COUNT; ++i) {
    #             HasRange[i]                 = false;
    #             Fit[i]                      = false;
    #             LinkedMin[i] = LinkedMax[i] = nullptr;
    #         }
    #     }
    def reset(self) -> None:
        """(private API)"""
        pass


class NextItemData:
    """ Temporary data storage for upcoming item"""
    # float           LineWeight;    /* original C++ signature */
    line_weight: float
    # ImPlotMarker    Marker;    /* original C++ signature */
    marker: Marker
    # float           MarkerSize;    /* original C++ signature */
    marker_size: float
    # float           MarkerWeight;    /* original C++ signature */
    marker_weight: float
    # float           FillAlpha;    /* original C++ signature */
    fill_alpha: float
    # float           ErrorBarSize;    /* original C++ signature */
    error_bar_size: float
    # float           ErrorBarWeight;    /* original C++ signature */
    error_bar_weight: float
    # float           DigitalBitHeight;    /* original C++ signature */
    digital_bit_height: float
    # float           DigitalBitGap;    /* original C++ signature */
    digital_bit_gap: float
    # bool            RenderLine;    /* original C++ signature */
    render_line: bool
    # bool            RenderFill;    /* original C++ signature */
    render_fill: bool
    # bool            RenderMarkerLine;    /* original C++ signature */
    render_marker_line: bool
    # bool            RenderMarkerFill;    /* original C++ signature */
    render_marker_fill: bool
    # bool            HasHidden;    /* original C++ signature */
    has_hidden: bool
    # bool            Hidden;    /* original C++ signature */
    hidden: bool
    # ImPlotCond      HiddenCond;    /* original C++ signature */
    hidden_cond: Cond
    # ImPlotNextItemData() { Reset(); }    /* original C++ signature */
    def __init__(self) -> None:
        pass
    # void Reset() {    /* original C++ signature */
    #         for (int i = 0; i < 5; ++i)
    #             Colors[i] = IMPLOT_AUTO_COL;
    #         LineWeight    = MarkerSize = MarkerWeight = FillAlpha = ErrorBarSize = ErrorBarWeight = DigitalBitHeight = DigitalBitGap = IMPLOT_AUTO;
    #         Marker        = IMPLOT_AUTO;
    #         HasHidden     = Hidden = false;
    #     }
    def reset(self) -> None:
        """(private API)"""
        pass

class Context:
    """ Holds state information that must persist between calls to BeginPlot()/EndPlot()"""
    # Plot States
    # ImPlotPlot*           CurrentPlot;    /* original C++ signature */
    current_plot: Plot
    # ImPlotSubplot*        CurrentSubplot;    /* original C++ signature */
    current_subplot: Subplot
    # ImPlotItemGroup*      CurrentItems;    /* original C++ signature */
    current_items: ItemGroup
    # ImPlotItem*           CurrentItem;    /* original C++ signature */
    current_item: Item
    # ImPlotItem*           PreviousItem;    /* original C++ signature */
    previous_item: Item

    # ImPlotTicker CTicker;    /* original C++ signature */
    # Tick Marks and Labels
    c_ticker: Ticker

    # Annotation and Tabs
    # ImPlotAnnotationCollection Annotations;    /* original C++ signature */
    annotations: AnnotationCollection
    # ImPlotTagCollection        Tags;    /* original C++ signature */
    tags: TagCollection

    # Style and Colormaps
    # ImPlotStyle                 Style;    /* original C++ signature */
    style: Style
    # ImVector<ImGuiColorMod>     ColorModifiers;    /* original C++ signature */
    color_modifiers: ImVector_ColorMod
    # ImVector<ImGuiStyleMod>     StyleModifiers;    /* original C++ signature */
    style_modifiers: ImVector_StyleMod
    # ImPlotColormapData          ColormapData;    /* original C++ signature */
    colormap_data: ColormapData


    # Temp data for general use
    # ImVector<int>      TempInt1;    /* original C++ signature */
    temp_int1: ImVector_int

    # Misc
    # int                DigitalPlotItemCnt;    /* original C++ signature */
    digital_plot_item_cnt: int
    # int                DigitalPlotOffset;    /* original C++ signature */
    digital_plot_offset: int
    # ImPlotNextPlotData NextPlotData;    /* original C++ signature */
    next_plot_data: NextPlotData
    # ImPlotNextItemData NextItemData;    /* original C++ signature */
    next_item_data: NextItemData
    # ImPlotInputMap     InputMap;    /* original C++ signature */
    input_map: InputMap
    # bool               OpenContextThisFrame;    /* original C++ signature */
    open_context_this_frame: bool
    # ImGuiTextBuffer    MousePosStringBuilder;    /* original C++ signature */
    mouse_pos_string_builder: TextBuffer
    # ImPlotItemGroup*   SortItems;    /* original C++ signature */
    sort_items: ItemGroup

    # Align plots
    # ImPlotAlignmentData*        CurrentAlignmentH;    /* original C++ signature */
    current_alignment_h: AlignmentData
    # ImPlotAlignmentData*        CurrentAlignmentV;    /* original C++ signature */
    current_alignment_v: AlignmentData

    # bool CanDragPlotInNodeEditor = false;    /* original C++ signature */
    # Specific to ImGui Bundle, when used inside imgui-node-editor
    can_drag_plot_in_node_editor: bool = False
    # ImPlotContext(ImPlotTicker CTicker = ImPlotTicker(), ImPlotAnnotationCollection Annotations = ImPlotAnnotationCollection(), ImPlotTagCollection Tags = ImPlotTagCollection(), ImPlotStyle Style = ImPlotStyle(), ImVector<ImGuiColorMod> ColorModifiers = ImVector<ImGuiColorMod>(), ImVector<ImGuiStyleMod> StyleModifiers = ImVector<ImGuiStyleMod>(), ImPlotColormapData ColormapData = ImPlotColormapData(), ImVector<int> TempInt1 = ImVector<int>(), int DigitalPlotItemCnt = int(), int DigitalPlotOffset = int(), ImPlotNextPlotData NextPlotData = ImPlotNextPlotData(), ImPlotNextItemData NextItemData = ImPlotNextItemData(), ImPlotInputMap InputMap = ImPlotInputMap(), bool OpenContextThisFrame = bool(), ImGuiTextBuffer MousePosStringBuilder = ImGuiTextBuffer(), bool CanDragPlotInNodeEditor = false);    /* original C++ signature */
    def __init__(self, c_ticker: Optional[Ticker] = None, annotations: Optional[AnnotationCollection] = None, tags: Optional[TagCollection] = None, style: Optional[Style] = None, color_modifiers: Optional[ImVector_ColorMod] = None, style_modifiers: Optional[ImVector_StyleMod] = None, colormap_data: Optional[ColormapData] = None, temp_int1: Optional[ImVector_int] = None, digital_plot_item_cnt: int = int(), digital_plot_offset: int = int(), next_plot_data: Optional[NextPlotData] = None, next_item_data: Optional[NextItemData] = None, input_map: Optional[InputMap] = None, open_context_this_frame: bool = bool(), mouse_pos_string_builder: Optional[TextBuffer] = None, can_drag_plot_in_node_editor: bool = False) -> None:
        """Auto-generated default constructor with named params
        ---
        Python bindings defaults:
            If any of the params below is None, then its default value below will be used:
                CTicker: Ticker()
                Annotations: AnnotationCollection()
                Tags: TagCollection()
                Style: Style()
                ColorModifiers: ImVector_ColorMod()
                StyleModifiers: ImVector_StyleMod()
                ColormapData: ColormapData()
                TempInt1: ImVector_int()
                NextPlotData: NextPlotData()
                NextItemData: NextItemData()
                InputMap: InputMap()
                MousePosStringBuilder: TextBuffer()
        """
        pass

#-----------------------------------------------------------------------------
# [SECTION] Internal API
# No guarantee of forward compatibility here!
#-----------------------------------------------------------------------------


#-----------------------------------------------------------------------------
# [SECTION] Context Utils
#-----------------------------------------------------------------------------

# IMPLOT_API void Initialize(ImPlotContext* ctx);    /* original C++ signature */
def initialize(ctx: Context) -> None:
    """ Initializes an ImPlotContext"""
    pass
# IMPLOT_API void ResetCtxForNextPlot(ImPlotContext* ctx);    /* original C++ signature */
def reset_ctx_for_next_plot(ctx: Context) -> None:
    """ Resets an ImPlot context for the next call to BeginPlot"""
    pass
# IMPLOT_API void ResetCtxForNextAlignedPlots(ImPlotContext* ctx);    /* original C++ signature */
def reset_ctx_for_next_aligned_plots(ctx: Context) -> None:
    """ Resets an ImPlot context for the next call to BeginAlignedPlots"""
    pass
# IMPLOT_API void ResetCtxForNextSubplot(ImPlotContext* ctx);    /* original C++ signature */
def reset_ctx_for_next_subplot(ctx: Context) -> None:
    """ Resets an ImPlot context for the next call to BeginSubplot"""
    pass

#-----------------------------------------------------------------------------
# [SECTION] Plot Utils
#-----------------------------------------------------------------------------

# IMPLOT_API ImPlotPlot* GetPlot(const char* title);    /* original C++ signature */
def get_plot(title: str) -> Plot:
    """ Gets a plot from the current ImPlotContext"""
    pass
# IMPLOT_API ImPlotPlot* GetCurrentPlot();    /* original C++ signature */
def get_current_plot() -> Plot:
    """ Gets the current plot from the current ImPlotContext"""
    pass
# IMPLOT_API void BustPlotCache();    /* original C++ signature */
def bust_plot_cache() -> None:
    """ Busts the cache for every plot in the current context"""
    pass

# IMPLOT_API void ShowPlotContextMenu(ImPlotPlot& plot);    /* original C++ signature */
def show_plot_context_menu(plot: Plot) -> None:
    """ Shows a plot's context menu."""
    pass

#-----------------------------------------------------------------------------
# [SECTION] Setup Utils
#-----------------------------------------------------------------------------

# static inline void SetupLock() {    /* original C++ signature */
#     ImPlotContext& gp = *GImPlot;
#     if (!gp.CurrentPlot->SetupLocked)
#         SetupFinish();
#     gp.CurrentPlot->SetupLocked = true;
# }
def setup_lock() -> None:
    """ Lock Setup and call SetupFinish if necessary.
    (private API)
    """
    pass

#-----------------------------------------------------------------------------
# [SECTION] Subplot Utils
#-----------------------------------------------------------------------------

# IMPLOT_API void SubplotNextCell();    /* original C++ signature */
def subplot_next_cell() -> None:
    """ Advances to next subplot"""
    pass

# IMPLOT_API void ShowSubplotsContextMenu(ImPlotSubplot& subplot);    /* original C++ signature */
def show_subplots_context_menu(subplot: Subplot) -> None:
    """ Shows a subplot's context menu."""
    pass

#-----------------------------------------------------------------------------
# [SECTION] Item Utils
#-----------------------------------------------------------------------------

# IMPLOT_API bool BeginItem(const char* label_id, ImPlotItemFlags flags=0, ImPlotCol recolor_from=IMPLOT_AUTO);    /* original C++ signature */
def begin_item(label_id: str, flags: ItemFlags = 0, recolor_from: Optional[Col] = None) -> bool:
    """ Begins a new item. Returns False if the item should not be plotted. Pushes PlotClipRect.
    ---
    Python bindings defaults:
        If recolor_from is None, then its default value will be: IMPLOT_AUTO
    """
    pass


# IMPLOT_API void EndItem();    /* original C++ signature */
def end_item() -> None:
    """ Ends an item (call only if BeginItem returns True). Pops PlotClipRect."""
    pass

# IMPLOT_API ImPlotItem* RegisterOrGetItem(const char* label_id, ImPlotItemFlags flags, bool* just_created = nullptr);    /* original C++ signature */
def register_or_get_item(label_id: str, flags: ItemFlags, just_created: Optional[bool] = None) -> Tuple[Item , Optional[bool]]:
    """ Register or get an existing item from the current plot."""
    pass
# IMPLOT_API ImPlotItem* GetItem(const char* label_id);    /* original C++ signature */
def get_item(label_id: str) -> Item:
    """ Get a plot item from the current plot."""
    pass
# IMPLOT_API ImPlotItem* GetCurrentItem();    /* original C++ signature */
def get_current_item() -> Item:
    """ Gets the current item."""
    pass
# IMPLOT_API void BustItemCache();    /* original C++ signature */
def bust_item_cache() -> None:
    """ Busts the cache for every item for every plot in the current context."""
    pass

#-----------------------------------------------------------------------------
# [SECTION] Axis Utils
#-----------------------------------------------------------------------------

# static inline bool AnyAxesInputLocked(ImPlotAxis* axes, int count) {    /* original C++ signature */
#     for (int i = 0; i < count; ++i) {
#         if (axes[i].Enabled && axes[i].IsInputLocked())
#             return true;
#     }
#     return false;
# }
def any_axes_input_locked(axes: Axis, count: int) -> bool:
    """ Returns True if any enabled axis is locked from user input.
    (private API)
    """
    pass

# static inline bool AllAxesInputLocked(ImPlotAxis* axes, int count) {    /* original C++ signature */
#     for (int i = 0; i < count; ++i) {
#         if (axes[i].Enabled && !axes[i].IsInputLocked())
#             return false;
#     }
#     return true;
# }
def all_axes_input_locked(axes: Axis, count: int) -> bool:
    """ Returns True if all enabled axes are locked from user input.
    (private API)
    """
    pass

# static inline bool AnyAxesHeld(ImPlotAxis* axes, int count) {    /* original C++ signature */
#     for (int i = 0; i < count; ++i) {
#         if (axes[i].Enabled && axes[i].Held)
#             return true;
#     }
#     return false;
# }
def any_axes_held(axes: Axis, count: int) -> bool:
    """(private API)"""
    pass

# static inline bool AnyAxesHovered(ImPlotAxis* axes, int count) {    /* original C++ signature */
#     for (int i = 0; i < count; ++i) {
#         if (axes[i].Enabled && axes[i].Hovered)
#             return true;
#     }
#     return false;
# }
def any_axes_hovered(axes: Axis, count: int) -> bool:
    """(private API)"""
    pass

# static inline bool FitThisFrame() {    /* original C++ signature */
#     return GImPlot->CurrentPlot->FitThisFrame;
# }
def fit_this_frame() -> bool:
    """ Returns True if the user has requested data to be fit.
    (private API)
    """
    pass

# static inline void FitPointX(double x) {    /* original C++ signature */
#     ImPlotPlot& plot   = *GetCurrentPlot();
#     ImPlotAxis& x_axis = plot.Axes[plot.CurrentX];
#     x_axis.ExtendFit(x);
# }
def fit_point_x(x: float) -> None:
    """ Extends the current plot's axes so that it encompasses a vertical line at x
    (private API)
    """
    pass

# static inline void FitPointY(double y) {    /* original C++ signature */
#     ImPlotPlot& plot   = *GetCurrentPlot();
#     ImPlotAxis& y_axis = plot.Axes[plot.CurrentY];
#     y_axis.ExtendFit(y);
# }
def fit_point_y(y: float) -> None:
    """ Extends the current plot's axes so that it encompasses a horizontal line at y
    (private API)
    """
    pass

# static inline void FitPoint(const ImPlotPoint& p) {    /* original C++ signature */
#     ImPlotPlot& plot   = *GetCurrentPlot();
#     ImPlotAxis& x_axis = plot.Axes[plot.CurrentX];
#     ImPlotAxis& y_axis = plot.Axes[plot.CurrentY];
#     x_axis.ExtendFitWith(y_axis, p.x, p.y);
#     y_axis.ExtendFitWith(x_axis, p.y, p.x);
# }
def fit_point(p: Point) -> None:
    """ Extends the current plot's axes so that it encompasses point p
    (private API)
    """
    pass

# static inline bool RangesOverlap(const ImPlotRange& r1, const ImPlotRange& r2)    /* original C++ signature */
# { return r1.Min <= r2.Max && r2.Min <= r1.Max; }
def ranges_overlap(r1: Range, r2: Range) -> bool:
    """ Returns True if two ranges overlap
    (private API)
    """
    pass

# IMPLOT_API void ShowAxisContextMenu(ImPlotAxis& axis, ImPlotAxis* equal_axis, bool time_allowed = false);    /* original C++ signature */
def show_axis_context_menu(axis: Axis, equal_axis: Axis, time_allowed: bool = False) -> None:
    """ Shows an axis's context menu."""
    pass

#-----------------------------------------------------------------------------
# [SECTION] Legend Utils
#-----------------------------------------------------------------------------

# IMPLOT_API ImVec2 GetLocationPos(const ImRect& outer_rect, const ImVec2& inner_size, ImPlotLocation location, const ImVec2& pad = ImVec2(0,0));    /* original C++ signature */
def get_location_pos(outer_rect: ImRect, inner_size: ImVec2Like, location: Location, pad: Optional[ImVec2Like] = None) -> ImVec2:
    """ Gets the position of an inner rect that is located inside of an outer rect according to an ImPlotLocation and padding amount.
    ---
    Python bindings defaults:
        If pad is None, then its default value will be: ImVec2(0,0)
    """
    pass
# IMPLOT_API ImVec2 CalcLegendSize(ImPlotItemGroup& items, const ImVec2& pad, const ImVec2& spacing, bool vertical);    /* original C++ signature */
def calc_legend_size(items: ItemGroup, pad: ImVec2Like, spacing: ImVec2Like, vertical: bool) -> ImVec2:
    """ Calculates the bounding box size of a legend _before_ clipping."""
    pass
# IMPLOT_API bool ClampLegendRect(ImRect& legend_rect, const ImRect& outer_rect, const ImVec2& pad);    /* original C++ signature */
def clamp_legend_rect(legend_rect: ImRect, outer_rect: ImRect, pad: ImVec2Like) -> bool:
    """ Clips calculated legend size"""
    pass
# IMPLOT_API bool ShowLegendEntries(ImPlotItemGroup& items, const ImRect& legend_bb, bool interactable, const ImVec2& pad, const ImVec2& spacing, bool vertical, ImDrawList& DrawList);    /* original C++ signature */
def show_legend_entries(items: ItemGroup, legend_bb: ImRect, interactable: bool, pad: ImVec2Like, spacing: ImVec2Like, vertical: bool, draw_list: ImDrawList) -> bool:
    """ Renders legend entries into a bounding box"""
    pass
# IMPLOT_API void ShowAltLegend(const char* title_id, bool vertical = true, const ImVec2 size = ImVec2(0,0), bool interactable = true);    /* original C++ signature */
def show_alt_legend(title_id: str, vertical: bool = True, size: Optional[ImVec2Like] = None, interactable: bool = True) -> None:
    """ Shows an alternate legend for the plot identified by #title_id, outside of the plot frame (can be called before or after of Begin/EndPlot but must occur in the same ImGui window! This is not thoroughly tested nor scrollable!).
    ---
    Python bindings defaults:
        If size is None, then its default value will be: ImVec2(0,0)
    """
    pass
# IMPLOT_API bool ShowLegendContextMenu(ImPlotLegend& legend, bool visible);    /* original C++ signature */
def show_legend_context_menu(legend: Legend, visible: bool) -> bool:
    """ Shows a legend's context menu."""
    pass

#-----------------------------------------------------------------------------
# [SECTION] Label Utils
#-----------------------------------------------------------------------------


#-----------------------------------------------------------------------------
# [SECTION] Styling Utils
#-----------------------------------------------------------------------------

# static inline const ImPlotNextItemData& GetItemData() { return GImPlot->NextItemData; }    /* original C++ signature */
def get_item_data() -> NextItemData:
    """ Get styling data for next item (call between Begin/EndItem)
    (private API)
    """
    pass

# static inline bool IsColorAuto(const ImVec4& col) { return col.w == -1; }    /* original C++ signature */
@overload
def is_color_auto(col: ImVec4Like) -> bool:
    """ Returns True if a color is set to be automatically determined
    (private API)
    """
    pass
# static inline bool IsColorAuto(ImPlotCol idx) { return IsColorAuto(GImPlot->Style.Colors[idx]); }    /* original C++ signature */
@overload
def is_color_auto(idx: Col) -> bool:
    """ Returns True if a style color is set to be automatically determined
    (private API)
    """
    pass
# IMPLOT_API ImVec4 GetAutoColor(ImPlotCol idx);    /* original C++ signature */
def get_auto_color(idx: Col) -> ImVec4:
    """ Returns the automatically deduced style color"""
    pass

# Returns the style color whether it is automatic or custom set
# static inline ImVec4 GetStyleColorVec4(ImPlotCol idx) { return IsColorAuto(idx) ? GetAutoColor(idx) : GImPlot->Style.Colors[idx]; }    /* original C++ signature */
def get_style_color_vec4(idx: Col) -> ImVec4:
    """(private API)"""
    pass
# static inline ImU32  GetStyleColorU32(ImPlotCol idx)  { return ImGui::ColorConvertFloat4ToU32(GetStyleColorVec4(idx)); }    /* original C++ signature */
def get_style_color_u32(idx: Col) -> ImU32:
    """(private API)"""
    pass

# IMPLOT_API void AddTextVertical(ImDrawList *DrawList, ImVec2 pos, ImU32 col, const char* text_begin, const char* text_end = nullptr);    /* original C++ signature */
def add_text_vertical(draw_list: ImDrawList, pos: ImVec2Like, col: ImU32, text_begin: str, text_end: Optional[str] = None) -> None:
    """ Draws vertical text. The position is the bottom left of the text rect."""
    pass
# IMPLOT_API void AddTextCentered(ImDrawList* DrawList, ImVec2 top_center, ImU32 col, const char* text_begin, const char* text_end = nullptr);    /* original C++ signature */
def add_text_centered(draw_list: ImDrawList, top_center: ImVec2Like, col: ImU32, text_begin: str, text_end: Optional[str] = None) -> None:
    """ Draws multiline horizontal text centered."""
    pass
# static inline ImVec2 CalcTextSizeVertical(const char *text) {    /* original C++ signature */
#     ImVec2 sz = ImGui::CalcTextSize(text);
#     return ImVec2(sz.y, sz.x);
# }
def calc_text_size_vertical(text: str) -> ImVec2:
    """ Calculates the size of vertical text
    (private API)
    """
    pass
# Returns white or black text given background color
# static inline ImU32 CalcTextColor(const ImVec4& bg) { return (bg.x * 0.299f + bg.y * 0.587f + bg.z * 0.114f) > 0.5f ? IM_COL32_BLACK : IM_COL32_WHITE; }    /* original C++ signature */
@overload
def calc_text_color(bg: ImVec4Like) -> ImU32:
    """(private API)"""
    pass
# static inline ImU32 CalcTextColor(ImU32 bg)         { return CalcTextColor(ImGui::ColorConvertU32ToFloat4(bg)); }    /* original C++ signature */
@overload
def calc_text_color(bg: ImU32) -> ImU32:
    """(private API)"""
    pass
# static inline ImU32 CalcHoverColor(ImU32 col)       {  return ImMixU32(col, CalcTextColor(col), 32); }    /* original C++ signature */
def calc_hover_color(col: ImU32) -> ImU32:
    """ Lightens or darkens a color for hover
    (private API)
    """
    pass

# static inline ImVec2 ClampLabelPos(ImVec2 pos, const ImVec2& size, const ImVec2& Min, const ImVec2& Max) {    /* original C++ signature */
#     if (pos.x < Min.x)              pos.x = Min.x;
#     if (pos.y < Min.y)              pos.y = Min.y;
#     if ((pos.x + size.x) > Max.x)   pos.x = Max.x - size.x;
#     if ((pos.y + size.y) > Max.y)   pos.y = Max.y - size.y;
#     return pos;
# }
def clamp_label_pos(pos: ImVec2Like, size: ImVec2Like, min: ImVec2Like, max: ImVec2Like) -> ImVec2:
    """ Clamps a label position so that it fits a rect defined by Min/Max
    (private API)
    """
    pass

# IMPLOT_API ImU32  GetColormapColorU32(int idx, ImPlotColormap cmap);    /* original C++ signature */
def get_colormap_color_u32(idx: int, cmap: Colormap) -> ImU32:
    """ Returns a color from the Color map given an index >= 0 (modulo will be performed)."""
    pass
# IMPLOT_API ImU32  NextColormapColorU32();    /* original C++ signature */
def next_colormap_color_u32() -> ImU32:
    """ Returns the next unused colormap color and advances the colormap. Can be used to skip colors if desired."""
    pass
# IMPLOT_API ImU32  SampleColormapU32(float t, ImPlotColormap cmap);    /* original C++ signature */
def sample_colormap_u32(t: float, cmap: Colormap) -> ImU32:
    """ Linearly interpolates a color from the current colormap given t between 0 and 1."""
    pass

# IMPLOT_API void RenderColorBar(const ImU32* colors, int size, ImDrawList& DrawList, const ImRect& bounds, bool vert, bool reversed, bool continuous);    /* original C++ signature */
def render_color_bar(colors: ImU32, size: int, draw_list: ImDrawList, bounds: ImRect, vert: bool, reversed: bool, continuous: bool) -> None:
    """ Render a colormap bar"""
    pass

#-----------------------------------------------------------------------------
# [SECTION] Math and Misc Utils
#-----------------------------------------------------------------------------

# IMPLOT_API double NiceNum(double x, bool round);    /* original C++ signature */
def nice_num(x: float, round: bool) -> float:
    """ Rounds x to powers of 2,5 and 10 for generating axis labels (from Graphics Gems 1 Chapter 11.2)"""
    pass
# static inline int OrderOfMagnitude(double val) { return val == 0 ? 0 : (int)(floor(log10(fabs(val)))); }    /* original C++ signature */
def order_of_magnitude(val: float) -> int:
    """ Computes order of magnitude of double.
    (private API)
    """
    pass
# static inline int OrderToPrecision(int order) { return order > 0 ? 0 : 1 - order; }    /* original C++ signature */
def order_to_precision(order: int) -> int:
    """ Returns the precision required for a order of magnitude.
    (private API)
    """
    pass
# static inline int Precision(double val) { return OrderToPrecision(OrderOfMagnitude(val)); }    /* original C++ signature */
def precision(val: float) -> int:
    """ Returns a floating point precision to use given a value
    (private API)
    """
    pass
# static inline double RoundTo(double val, int prec) { double p = pow(10,(double)prec); return floor(val*p+0.5)/p; }    /* original C++ signature */
def round_to(val: float, prec: int) -> float:
    """ Round a value to a given precision
    (private API)
    """
    pass

# static inline ImVec2 Intersection(const ImVec2& a1, const ImVec2& a2, const ImVec2& b1, const ImVec2& b2) {    /* original C++ signature */
#     float v1 = (a1.x * a2.y - a1.y * a2.x);  float v2 = (b1.x * b2.y - b1.y * b2.x);
#     float v3 = ((a1.x - a2.x) * (b1.y - b2.y) - (a1.y - a2.y) * (b1.x - b2.x));
#     return ImVec2((v1 * (b1.x - b2.x) - v2 * (a1.x - a2.x)) / v3, (v1 * (b1.y - b2.y) - v2 * (a1.y - a2.y)) / v3);
# }
def intersection(a1: ImVec2Like, a2: ImVec2Like, b1: ImVec2Like, b2: ImVec2Like) -> ImVec2:
    """ Returns the intersection point of two lines A and B (assumes they are not parallel!)
    (private API)
    """
    pass



#-----------------------------------------------------------------------------
# Time Utils
#-----------------------------------------------------------------------------

# static inline bool IsLeapYear(int year) {    /* original C++ signature */
#     return  year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
# }
def is_leap_year(year: int) -> bool:
    """ Returns True if year is leap year (366 days long)
    (private API)
    """
    pass
# static inline int GetDaysInMonth(int year, int month) {    /* original C++ signature */
#     static const int days[12] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
#     return  days[month] + (int)(month == 1 && IsLeapYear(year));
# }
def get_days_in_month(year: int, month: int) -> int:
    """ Returns the number of days in a month, accounting for Feb. leap years. #month is zero indexed.
    (private API)
    """
    pass



# NB: The following functions only work if there is a current ImPlotContext because the
# internal tm struct is owned by the context! They are aware of ImPlotStyle.UseLocalTime.

# IMPLOT_API ImPlotTime MakeTime(int year, int month = 0, int day = 1, int hour = 0, int min = 0, int sec = 0, int us = 0);    /* original C++ signature */
def make_time(year: int, month: int = 0, day: int = 1, hour: int = 0, min: int = 0, sec: int = 0, us: int = 0) -> Time:
    """ Make a timestamp from time components.
     year[1970-3000], month[0-11], day[1-31], hour[0-23], min[0-59], sec[0-59], us[0,999999]
    """
    pass
# IMPLOT_API int GetYear(const ImPlotTime& t);    /* original C++ signature */
def get_year(t: Time) -> int:
    """ Get year component from timestamp [1970-3000]"""
    pass

# IMPLOT_API ImPlotTime AddTime(const ImPlotTime& t, ImPlotTimeUnit unit, int count);    /* original C++ signature */
def add_time(t: Time, unit: TimeUnit, count: int) -> Time:
    """ Adds or subtracts time from a timestamp. #count > 0 to add, < 0 to subtract."""
    pass
# IMPLOT_API ImPlotTime FloorTime(const ImPlotTime& t, ImPlotTimeUnit unit);    /* original C++ signature */
def floor_time(t: Time, unit: TimeUnit) -> Time:
    """ Rounds a timestamp down to nearest unit."""
    pass
# IMPLOT_API ImPlotTime CeilTime(const ImPlotTime& t, ImPlotTimeUnit unit);    /* original C++ signature */
def ceil_time(t: Time, unit: TimeUnit) -> Time:
    """ Rounds a timestamp up to the nearest unit."""
    pass
# IMPLOT_API ImPlotTime RoundTime(const ImPlotTime& t, ImPlotTimeUnit unit);    /* original C++ signature */
def round_time(t: Time, unit: TimeUnit) -> Time:
    """ Rounds a timestamp up or down to the nearest unit."""
    pass
# IMPLOT_API ImPlotTime CombineDateTime(const ImPlotTime& date_part, const ImPlotTime& time_part);    /* original C++ signature */
def combine_date_time(date_part: Time, time_part: Time) -> Time:
    """ Combines the date of one timestamp with the time-of-day of another timestamp."""
    pass


# IMPLOT_API bool ShowDatePicker(const char* id, int* level, ImPlotTime* t, const ImPlotTime* t1 = nullptr, const ImPlotTime* t2 = nullptr);    /* original C++ signature */
def show_date_picker(id_: str, level: int, t: Time, t1: Optional[Time] = None, t2: Optional[Time] = None) -> Tuple[bool, int]:
    """ Shows a date picker widget block (year/month/day).
     #level = 0 for day, 1 for month, 2 for year. Modified by user interaction.
     #t will be set when a day is clicked and the function will return True.
     #t1 and #t2 are optional dates to highlight.
    """
    pass
# IMPLOT_API bool ShowTimePicker(const char* id, ImPlotTime* t);    /* original C++ signature */
def show_time_picker(id_: str, t: Time) -> bool:
    """ Shows a time picker widget block (hour/min/sec).
     #t will be set when a new hour, minute, or sec is selected or am/pm is toggled, and the function will return True.
    """
    pass

#-----------------------------------------------------------------------------
# [SECTION] Transforms
#-----------------------------------------------------------------------------

# static inline double TransformForward_Log10(double v, void*) {    /* original C++ signature */
#     v = v <= 0.0 ? DBL_MIN : v;
#     return ImLog10(v);
# }
def transform_forward_log10(v: float, param_1: Any) -> float:
    """(private API)"""
    pass

# static inline double TransformInverse_Log10(double v, void*) {    /* original C++ signature */
#     return ImPow(10, v);
# }
def transform_inverse_log10(v: float, param_1: Any) -> float:
    """(private API)"""
    pass

# static inline double TransformForward_SymLog(double v, void*) {    /* original C++ signature */
#     return 2.0 * ImAsinh(v / 2.0);
# }
def transform_forward_sym_log(v: float, param_1: Any) -> float:
    """(private API)"""
    pass

# static inline double TransformInverse_SymLog(double v, void*) {    /* original C++ signature */
#     return 2.0 * ImSinh(v / 2.0);
# }
def transform_inverse_sym_log(v: float, param_1: Any) -> float:
    """(private API)"""
    pass

# static inline double TransformForward_Logit(double v, void*) {    /* original C++ signature */
#     v = ImClamp(v, DBL_MIN, 1.0 - DBL_EPSILON);
#     return ImLog10(v / (1 - v));
# }
def transform_forward_logit(v: float, param_1: Any) -> float:
    """(private API)"""
    pass

# static inline double TransformInverse_Logit(double v, void*) {    /* original C++ signature */
#     return 1.0 / (1.0 + ImPow(10,-v));
# }
def transform_inverse_logit(v: float, param_1: Any) -> float:
    """(private API)"""
    pass

#-----------------------------------------------------------------------------
# [SECTION] Formatters
#-----------------------------------------------------------------------------



class Formatter_Time_Data:
    # ImPlotTime Time;    /* original C++ signature */
    time: Time
    # ImPlotDateTimeSpec Spec;    /* original C++ signature */
    spec: DateTimeSpec
    # void* UserFormatterData;    /* original C++ signature */
    user_formatter_data: Any
    # Formatter_Time_Data(ImPlotTime Time = ImPlotTime(), ImPlotDateTimeSpec Spec = ImPlotDateTimeSpec());    /* original C++ signature */
    def __init__(self, time: Optional[Time] = None, spec: Optional[DateTimeSpec] = None) -> None:
        """Auto-generated default constructor with named params
        ---
        Python bindings defaults:
            If any of the params below is None, then its default value below will be used:
                Time: Time()
                Spec: DateTimeSpec()
        """
        pass


#------------------------------------------------------------------------------
# [SECTION] Locator
#------------------------------------------------------------------------------



# namespace ImPlot

# #endif
####################    </generated_from:implot_internal.h>    ####################

# </litgen_stub>
# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
